#pragma rtGlobals=1	// Use modern global access method.
#include "IR1_Loader"
#include <ProcedureBrowser>
//#include "DWS_GeneralGraphControls"
//#include "DWS_GeneralGraph"
#pragma rtGlobals=1		// Use modern global access method.
menu "Plot&fit"
	SUBMENu "Major tools"
		"Distribution Recovery Panel",RecoverSizesPanel()	
	end
end

function testformfactor(qvalue)
	variable qvalue
	variable Rcluster= 50000,PriParticleRadius=100,D=2,result
	result=IR1T_FractalAggofSpheresFF(qvalue,Rcluster,PriParticleRadius,D,1,1,1)
end

function plotff()
	make/O/N=100 qwave
	qwave=.00001+p/100
	//logspacing(qwave)
	duplicate/O qwave,rwave
	rwave=testformfactor(qwave)
	display rwave vs qwave
end



Function GraphIntensityfromDistribution()
	SVAR DataFolderName=root:Packages:Sizes:DataFolderName	
	//SVAR Shapetype=root:Packages:Sizes:ShapeType
	NVAR  AspectRatio=root:Packages:Sizes:AspectRatio
	setdatafolder DataFolderName
	SVAR FitQvectorWvName=root:Packages:Sizes:FitQvectorWvName
	SVAR DiameterWaveName=root:Packages:Sizes:DiameterWaveName
	wave DiameterWave=$DiameterWaveName
	duplicate/O DiameterWave,RadiusWave
	Radiuswave*=0.5
	string oldnote=note(DiameterWave)
	string SizesVolumeDistributionName="SizesVolumeDistribution"+DiameterWaveName[17,inf]
	string SizesNumberDistributionName="SizesNumberDistribution"+DiameterWaveName[17,inf]
	wave SizesNumberDistribution=$SizesNumberDistributionName
	wave  SizesVolumeDistribution=$SizesVolumeDistributionName
	wave Q_Model=$FitQvectorWvName
	//string wavenote=note(DiameterWave)
	string shapetype=StringByKey("ParticleShape", oldnote ,"=",";")

	duplicate/O SizesVolumeDistribution, Gmatrix  //rank is number of D values
	string cmd
	
	if(cmpstr(ShapeType,"Algebraic_Integrated Spheres")==0)		//no parameter at all - it is sphere
			//no parameter
		elseif(cmpstr(ShapeType,"Cylinders")==0)						//Cylinder 1 poarameter - length
			NVAR CylinderLength=root:Packages:Sizes:CylinderLength	//CylinderLength
			CylinderLength			=NumberbyKey("CylinderLength", OldNote,"=")
			IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,shapetype,CylinderLength,1,1,1,1, "", "")  //Cylinder 1 parameter - length
		elseif(cmpstr(ShapeType,"User")==0)						
			NVAR ParticlePar1G=root:Packages:Sizes:UserFFpar1
			ParticlePar1G			=NumberbyKey("UserParameter1", OldNote,"=")
			NVAR ParticlePar2G=root:Packages:Sizes:UserFFpar2
			ParticlePar2G			=NumberbyKey("UserParameter2", OldNote,"=")
			NVAR ParticlePar3G=root:Packages:Sizes:UserFFpar3
			ParticlePar3G			=NumberbyKey("UserParameter3", OldNote,"=")
			NVAR ParticlePar4G=root:Packages:Sizes:UserFFpar4
			ParticlePar4G			=NumberbyKey("UserParameter4", OldNote,"=")
			NVAR ParticlePar5G=root:Packages:Sizes:UserFFpar5
			ParticlePar5G			=NumberbyKey("UserParameter5", OldNote,"=")
			Doalert 0, "User model not implemented yet.  DWS"
			abort
		elseif(cmpstr(ShapeType,"CoreShell")==0)				//CoreShell - 2 parameters
			NVAR CoreShellThicknessRatio=root:Packages:Sizes:CoreShellThicknessRatio	//radius of primary particle
			CoreShellThicknessRatio	=NumberbyKey("CoreShellThicknessRatio", OldNote,"=")//param 1
			NVAR CoreShellContrastRatio=root:Packages:Sizes:CoreShellContrastRatio	
			CoreShellContrastRatio	=NumberbyKey("CoreShellContrastRatio", OldNote,"=")//param2
			IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,shapetype,CoreShellThicknessRatio,CoreShellContrastRatio,1,1,1, "", "")
		elseif(cmpstr(ShapeType,"Fractal aggregate")==0)				//Fractal aggregate - 2 parameters
			NVAR FractalRadiusOfPriPart=root:Packages:Sizes:FractalRadiusOfPriPart	//radius of primary particle
			FractalRadiusOfPriPart	=NumberbyKey("FractalRadiusOfPriPart", OldNote,"=")
			NVAR FractalDimension=root:Packages:Sizes:FractalDimension	
			FractalDimension			=NumberbyKey("FractalDimension", OldNote,"=")
			IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,shapetype,FractalRadiusOfPriPart,FractalDimension,1,1,1, "", "")
		
			
		elseif((cmpstr(ShapeType,"Tube")==0)||(cmpstr(ShapeType,"Unified_Tube")==0)	)//dws			//Tube - 3 parameters
			NVAR TubeLength=root:Packages:Sizes:TubeLength			//TubeLength
				TubeLength				=NumberbyKey("TubeLength", OldNote,"=")
			NVAR TubeWallThickness=root:Packages:Sizes:TubeWallThickness		//WallThickness
				TubeWallThickness		=NumberbyKey("TubeWallThickness", OldNote,"=")	
			NVAR TubeCoreContrastRatio=root:Packages:Sizes:TubeCoreContrastRatio		//CoreContrastRatio
				TubeCoreContrastRatio	=NumberbyKey("TubeCoreContrastRatio", OldNote,"=")	
			 IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,shapetype,tubelength,TubeWallThickness,1,1,1, "", "")  
			//cmd="IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,\""+shapetype+"\","+num2str(tubelength)+","+num2str(TubeWallThickness)+",1,1,1, \"\", \"\")"
			//	IR1T_GenerateGMatrix(G_matrixFF, Q_vec,R_distribution,1,ShapeType,ParticlePar1,ParticlePar2,ParticlePar3,ParticlePar4,ParticlePar5,User_FormFactorFnct,User_FormFactorVol)

		else												//the ones which require 1 parameter - aspect ratio or (Unif) thickness/length
			AspectRatio				=NumberbyKey("AspectRatio", OldNote,"=")
			IR1T_GenerateGMatrix(Gmatrix,Q_Model,RadiusWave,1,shapetype,aspectratio,1,1,1,1, "", "")  
			
		endif
    
	variable contrast=numberByKey("ScatteringContrast", oldnote ,"=",";")
	Gmatrix*=contrast*1e20
	string R_ModelName="R_Model"+Diameterwavename[17,inf]

	Duplicate/O Q_Model, $R_ModelName
	Wave R_Model=$R_ModelName

        Duplicate/o SizesVolumeDistribution, tempVolDist
        tempVolDist = SizesVolumeDistribution[p]* IR1_BinWidthInDiameters(DiameterWave,p)
        MatrixOp/O R_Model =Gmatrix x  tempVolDist

	//MatrixOp/O R_Model =Gmatrix x SizesVolumeDistribution
	string tagstring=Recover_Sizes_Parameters(DiameterWaveName)
	if(cmpstr(WinList("IvsQfromModeL",";","WIN:1"), "" )==0)
		display/k=1/N=IvsQfromModel R_model vs Q_model	
		DoWindow /T IvsQfromModel, "IvsQfromModel"
		Label left "\\Z14Intensity";DelayUpdate;Label bottom "\\Z14Diameter ()"
	else
		appendtograph  $R_modelName vs Q_model
	Endif
	CheckforLog()
	Tag/C/N=$Diameterwavename/L=1 $R_modelname, 50,Tagstring
	killwaves/z Gmatrix,radiuswave,tempvolDist
end


function RecoverSizesPanel()
	IN2G_CheckScreenSize("height",670)
	IR1R_InitializeSizes()
	IR2D_DWSPlotToolInit()
	setdatafolder root:packages:sizes
	
	string ListOfStrings="DistributionWaveName;DiameterWaveName;DataFolderName;RgWaveName;FitQvectorWvName"
	variable i=0
	for(i=0;i<itemsInList(ListOfstrings);i+=1)	
		IN2G_CreateItem("string",StringFromList(i,ListOfstrings))
	endfor
	
	string ListOfvariables="UseRg;UseNumberDistribution"
	i=0
	for(i=0;i<itemsInList(ListOfstrings);i+=1)	
		IN2G_CreateItem("variable",StringFromList(i,ListOfvariables))
	endfor
	dowindow/K DWS_Sizes_Panel
	NewPanel /K=1/N=DWS_Sizes_Panel /W=(50,43,430,410) as "Sizes Distribution Panel"
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 18,fstyle= 3,textrgb= (0,0,52224)
	DrawText 57,22,"Size Distribution Recovery Panel"

	
	SetDrawEnv fsize= 16,fstyle= 1
	DrawText 8,49,"Data input"
	variable ypos

	CheckBox GraphLogX pos={100,26},title="Log X axis?", variable=root:Packages:GeneralplottingTool:GraphLogX
	CheckBox GraphLogX proc=IR2D_DWSGenPlotCheckBox
	CheckBox GraphLogY pos={100,40},title="Log Y axis?", variable=root:Packages:GeneralplottingTool:GraphLogY
	CheckBox GraphLogY proc=IR2D_DWSGenPlotCheckBox
	CheckBox UseIndra2Data,pos={100,54},proc=DWS_RgPanelCheckboxProc,title="Use Indra"
	CheckBox UseIndra2Data,variable= root:packages:Sizes:UseIndra2data
	
	CheckBox UseRg,pos={217,26},proc=DWS_RgPanelCheckboxProc,title="Plot vs Rg"
	CheckBox UseRg,variable= root:packages:Sizes:UseRg
	CheckBox UseNumberDist,pos={217,40},proc=DWS_RgPanelCheckboxProc,title="Number Distribution"
	CheckBox UseNumberDist,variable= root:packages:Sizes:UseNumberDistribution
	CheckBox UseQRSData,pos={217,54},proc=DWS_RgPanelCheckboxProc,title="Use QRS"
	CheckBox UseQRSData,variable= root:packages:Sizes:UseQRSdata
	
	YPOS=80
	PopupMenu SelectFolderIntensity,pos={8,YPOS},size={144,21},proc=DWS_PanelPopupControl2,title="Folder"
	PopupMenu SelectFolderIntensity,mode=1,popvalue="---",value= #"\"---;\"+IR1_GenStringOfFolders(root:Packages:Sizes:UseIndra2Data,root:Packages:Sizes:UseQRSData,root:Packages:Sizes:UseSlitSmearedData,0)"
	PopupMenu XaxisWaveName,pos={9,YPOS+25},size={179,21},proc=DWS_PanelPopupControl2,title="Diameter"
	PopupMenu XaxisWaveName,mode=1,popvalue="---",value= #"\"---;\"+ DWS_ListOfDist(\"Xaxis\")"
	PopupMenu YaxisWaveName,pos={8,YPOS+50},size={180,21},proc=DWS_PanelPopupControl2,title="Distribution"
	PopupMenu YaxisWaveName,mode=1,popvalue="---",value= #"\"---;\"+ DWS_ListOfDist(\"Yaxis\")"
	YPOS=160
	Button  RecoverSizeDist,pos={20,YPOS},size={120,20}, font="Times New Roman",fSize=11,proc=  DWS_RgPanelButtonProc,title=" Recover Distribution"
	Button  GraphIntensity,pos={150,YPOS},size={120,20}, font="Times New Roman",fSize=11,proc= DWS_RgPanelButtonProc,title="Graph Intensity"
	Button  Plotsizes,pos={20,YPOS+25},size={120,20}, font="Times New Roman",fSize=11,proc=DWS_RgPanelButtonProc,title="Graph Distribution"
       Button SaveGraph,pos={250,YPOS+25},size={80,20},font="Times New Roman",fSize=11,proc=DWS_InputPanelButtonProc,title="Save Graph"
	Button Standard,pos={150,YPOS+25},size={85,20},font="Times New Roman",fSize=11,proc=DWS_InputPanelButtonProc,title="Standard Graph"
	YPOS+=50
	SetDrawEnv linethick= 3,linefgc= (0,0,52224)
	DrawLine 16,YPOS,339,YPOS
	Button  Delete,pos={20,215},size={120,20}, font="Times New Roman",fSize=11,proc=DWS_RgPanelButtonProc,title="Remove Distribution"
	YPOS+=30
	SetDrawEnv linethick= 3,linefgc= (0,0,52224)
	DrawLine 16,YPOS,339,YPOS
	ypos +=10

	
	PopupMenu SelectQvector,pos={17,Ypos},size={137,21},proc=IR1R_PopMenuProc,title="Q data:           ", help={"Select wave with Q data (in A-1) "}
	PopupMenu SelectQvector,mode=1,popvalue="---",value= #"\"---;\"+IR1R_ListOfWaves(\"DSM_Qvec\")"
	PopupMenu SelectIntensity,pos={17,Ypos+25},size={135,21},proc=IR1R_PopMenuProc,title="Intensity data:", help={"Select wave with Intensity"}
	PopupMenu SelectIntensity,mode=1,popvalue="---",value= #"\"---;\"+IR1R_ListOfWaves(\"DSM_Int\")"
	PopupMenu SelectError,pos={17,Ypos+50},size={118,21},proc=IR1R_PopMenuProc,title="Error data:      ", help={"Select wave with Errors."}
	PopupMenu SelectError,mode=1,popvalue="---",value= #"\"---;\"+IR1R_ListOfWaves(\"DSM_Error\")"
	
	Button GraphI,pos={20,YPOS+ 75},size={100,21},font="Times New Roman",fSize=10,proc=DWS_GraphIntensityButton,title="Graph Intensity", help={"Push to graph data"}
end

Function DWS_RgPanelCheckboxProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	if (cmpstr(ctrlName,"UseRg")==0)		
		NVAR UseRg=root:Packages:Sizes:UseRg
		UseRg=checked
	endif
	if (cmpstr(ctrlName,"UseNumberDist")==0)
		NVAR UseNumberDistribution=root:Packages:Sizes:UseNumberDistribution
		UseNumberDistribution=checked
		SVAR DiameterWaveName=root:Packages:Sizes:DiameterWaveName
		DWS_PanelPopupControl2("XaxisWaveName",1,DiameterWaveName)
	endif
	if (cmpstr(ctrlName,"UseIndra2Data")==0)
		//here we control the data structure checkbox
		NVAR UseIndra2Data=root:Packages:Sizes:UseIndra2Data
		NVAR UseQRSData=root:Packages:Sizes:UseQRSData
		UseIndra2Data=checked
		if (checked)
			UseQRSData=0
		endif
	endif
	if (cmpstr(ctrlName,"UseQRSData")==0)
		//here we control the data structure checkbox
		NVAR UseQRSData=root:Packages:Sizes:UseQRSData
		NVAR UseIndra2Data=root:Packages:Sizes:UseIndra2Data		
		UseQRSData=checked
		if (checked)
			UseIndra2Data=0
		endif
	endif
end



Function  DWS_RgPanelButtonProc(ctrlName)
	STRING ctrlName
	string wavenote,method,num,Rgwavename
	SVAR workingfoldername=root:Packages:Sizes:DataFolderName
		setdatafolder workingfoldername
	SVAR DiameterWaveName=root:Packages:Sizes:DiameterWaveName
	wave DiameterWave =$DiameterWaveName
	
	SVAR Distributionwavename=root:Packages:Sizes:DistributionWaveName
	wave Distributionwave= $Distributionwavename
	SVAR RgWvname=root:Packages:Sizes:Rgwavename
	NVAR UseRg=root:Packages:Sizes:UseRg
	if (cmpstr(ctrlName,"Delete")==0)
			Doalert 0, "not implemented"
               // string deletewavenames=WaveList("*"+DiameterWaveName[17,inf],",","")       
            //  RemoveFromGraph $Distributionwavename
             //  doupdate
            //   doalert 2,"Do you want to permanently delete all waves associated with "+DiameterWaveName+"?"
            //   if (V_flag)
              //	 Execute("Killwaves/z "+deletewavenames) 
              	// Execute("Killstrings/z SizesParameters"+DiameterWaveName[17,inf]) 
             // endif
	endif 
	if (cmpstr(ctrlName,"GraphIntensity")==0)
		GraphIntensityfromDistribution()
	endif
	
	if (cmpstr(ctrlName,"RecoverSizeDist")==0)
		DiameterWaveName=DWS_RecoverOldParameters()		
		DWS_PanelPopupControl2("XaxisWaveName",1,DiameterWaveName)
	endif	
	
	wave Distributionwave= $Distributionwavename
	wavenote= note( Distributionwave)
	variable ratio,D
	D=NumberByKey("FractalDimension", wavenote ,"=",";")
	ratio=NumberByKey("AspectRatio", wavenote ,"=",";")	
	
	if ((cmpstr(ctrlName,"calcRg")==0)||(cmpstr(ctrlName,"Plotsizes")==0))
		string tagstring=Recover_Sizes_Parameters(Distributionwavename)
		If(useRg)	
			string shape=StringByKey("ParticleShape", wavenote ,"=",";")
			num=DiameterWaveName[17,18]
			Rgwavename=DiameterWaveName[0,8]+"Rg"+num
			duplicate/o DiameterWave,$Rgwavename
			wave rgwave=$Rgwavename
			rgwave=rgwave/2//convert from diameter to radius
			RgWvname=Rgwavename
			 if(stringmatch(shape, "Spheroid")==1) 
				Rgwave = sqrt(Rgwave^2* (2+ratio^2)/5)
			elseif(stringmatch(shape, "Algebraic_Rods")==1)
		     	 	 Rgwave = sqrt((Rgwave/2)^2/2+ (2*Rgwave*ratio)^2/12)//not sure this is correct.  What is meaning of aspect?
			elseif(stringmatch(shape, "*Sphere")==1)
				Rgwave = sqrt(3*Rgwave^2/5)
			elseif(stringmatch(shape, "*fractal aggregate")==1)
				Rgwave = (Rgwave)*sqrt(D*(D+1)/2)
			else
				Doalert 0, "Rg not implemented for " +shape+" shape"
				abort
			endif
		endif
			
	
      if (cmpstr(ctrlName,"Plotsizes")==0)   
      		string plotsizewavename=DiameterWaveName
      		string bottomaxislabel="Diameter ()"
      		If(useRg)
      			 plotsizewavename=Rgwavename
      			 bottomaxislabel="Rg ()"
      		endif
      			wave plotsizewave=$plotsizewavename
      			
      			//duplicate/o distributionwave,fractaldistributionwave
      			//fractaldistributionwave=fractaldistributionwave*(plotsizewave/500)^D
		if(cmpstr(WinList("DistributionVsSize",";","WIN:1"), "" )==0)
			Display/K=1/n=DistributionVsSize  Distributionwave vs plotsizewave
			DoWindow /T DistributionVsSize, "DistributionVsSize"
			//Label left "\\Z14Volume Distribution"//+Distributionwavename	
			Label bottom "\\Z14"+bottomaxislabel
			//Legend/C/N=legend1/A=MC
			ModifyGraph margin(bottom)=50
			//SetAxis bottom 1000,2000000 			
		else
			AppendToGraph Distributionwave vs plotsizewave
		endif		
		Tag/C/N=$Distributionwavename/L=1 $Distributionwavename, 50,Tagstring
		SVAR 	ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
		variable checkedbottom=str2num( stringbykey("log(bottom)",ListOfGraphFormating,"="))
		IR2D_DWSGenPlotCheckBox("GraphLogx",checkedbottom)	
		variable checkedleft=str2num( stringbykey("log(left)",ListOfGraphFormating,"="))
		IR2D_DWSGenPlotCheckBox("GraphLogy",checkedleft)	
		print  !strsearch(Distributionwavename, "Number", 0)==-1
		if( strsearch(Distributionwavename, "Number", 0)!=-1)
			Label left "\\Z14Number Distribution"	
		Else
			Label left "\\Z14Volume Distribution"	
		endif		
	endif	

endif	

if (cmpstr(ctrlName,"Delete")==0)
			Doalert 0, "not implemented"
               // string deletewavenames=WaveList("*"+DiameterWaveName[17,inf],",","")       
            //  RemoveFromGraph $Distributionwavename
             //  doupdate
            //   doalert 2,"Do you want to permanently delete all waves associated with "+DiameterWaveName+"?"
            //   if (V_flag)
              //	 Execute("Killwaves/z "+deletewavenames) 
              	// Execute("Killstrings/z SizesParameters"+DiameterWaveName[17,inf]) 
             // endif
	endif 
	if (cmpstr(ctrlName,"GraphIntensity")==0)
		GraphIntensityfromDistribution()
endif
END

Function/T DWS_ListOfDist(DataType)
	string DataType			//data type   : Xaxis, Yaxis, Error
	
	SVAR FldrNm=root:Packages:Sizes:DataFolderName
	string result="", tempresult="", tempStringQ="", tempStringR="", tempStringS="",matchstring="*vol*"
	NVAR UseNumberDistribution=root:Packages:Sizes:UseNumberDistribution
	If (UseNumberDistribution==1)
		matchstring="*num*"
	endif
	
	variable i,j
		
		result=IN2G_CreateListOfItemsInFolder(FldrNm,2)
		tempresult=""
		if(cmpstr(DataType,"Xaxis")==0)
			if(stringMatch(result,"*Diameter*"))
				for (i=0;i<ItemsInList(result);i+=1)
					if (stringMatch(StringFromList(i,result),"*Diameter*"))
						tempresult+=StringFromList(i,result)+";"
					endif
				endfor
			endif
		endif
		if(cmpstr(DataType,"Yaxis")==0)
			
			if(stringMatch(result,matchstring))
				for (i=0;i<ItemsInList(result);i+=1)
					if (stringMatch(StringFromList(i,result),matchstring))
						tempresult+=StringFromList(i,result)+";"
					endif
				endfor
			endif
		endif
		return tempresult
end

Function DWS_PanelPopupControl2(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr
	setDataFolder root:Packages:Sizes
	string oldDf=GetDataFolder(1),DistType="SizesVolumeDistribution_", cmd
	
	NVAR UseNumberDistribution=root:Packages:Sizes:UseNumberDistribution
		
	If (UseNumberDistribution)
		DistType="SizesNumberDistribution_"
	endif
	
	SVAR DistributionWaveName=root:Packages:Sizes:DistributionWaveName
	SVAR DiameterWaveName=root:Packages:Sizes:DiameterWaveName
	SVAR FitQvectorWvName=root:Packages:Sizes:FitQvectorWvName

	if (cmpstr(ctrlName,"SelectDataFolder")==0)
		SVAR Dtf=root:Packages:Sizes:DataFolderName
		Dtf=popStr
		PopupMenu YaxisWaveName mode=1,value= #"\"---;\"+ DWS_ListOfDist(\"yaxis\",win=IR1R_SizesInputPanel)"
		PopupMenu XaxisWaveName mode=1,value= #"\"---;\"+ DWS_ListOfDist(\"Xaxis\",win=IR1R_SizesInputPanel)"
		//PopupMenu SelectDataFolder value=root:Packages:Sizes:DataFolderName
		if (cmpstr(popStr,"---")==0)
			DistributionWaveName=""
			DiameterWaveName=""
			PopupMenu YaxisWaveName  value="---"
			PopupMenu XaxisWaveName value="---"
		endif
	endif
	
	if (cmpstr(ctrlName,"XaxisWaveName")==0)
		//here goes what needs to be done, when we select this popup...
		if (cmpstr(popStr,"---")!=0)
			DiameterWaveName=popStr				
				DistributionWaveName=DistType+DiameterWaveName[18,inf]
				FitQvectorWvName="SizesFitQvector"+DiameterWaveName[17,inf]
				cmd= "PopupMenu XaxisWaveName mode=1 ,win=DWS_Sizes_Panel,value=\""+DiameterWaveName+"\"+\";---;\"+DWS_ListOfDist(\"Xaxis\")"	
				Execute (cmd)				
				Execute ("PopupMenu YaxisWaveName mode=1,win=DWS_Sizes_Panel, value=root:Packages:Sizes:DistributionWaveName+\";---;\"+DWS_ListOfDist(\"Yaxis\")")
				Recover_Sizes_Parameters(DiameterWaveName)
				execute ("PopupMenu SelectQvector mode=1, value=root:Packages:Sizes:OriginalQvectorWvName,win=DWS_Sizes_Panel")
				execute ("PopupMenu SelectIntensity  mode=1,value=root:Packages:Sizes:OriginalIntensityWvName,win=DWS_Sizes_Panel")
				execute ("PopupMenu SelectError mode=1,value=root:Packages:Sizes:OriginalErrorWvName,win=DWS_Sizes_Panel")
		else
			DiameterWaveName=""
		endif
	endif

	if (cmpstr(ctrlName,"YaxisWaveName")==0)
		if (cmpstr(popStr,"---")!=0)
			DistributionWaveName=popStr
				DiameterWaveName=IR1P_CheckRightResultsWvs(popStr)	
				FitQvectorWvName="SizesFitQvector"+DiameterWaveName[17,inf]
				cmd = "PopupMenu XaxisWaveName,win=DWS_Sizes_Panel. mode=1, value=\""+DistributionWaveName+"\"+\";---;\"+DWS_ListOfDist(\"Yaxis\")"	
				Execute (cmd)
				cmd= "PopupMenu XaxisWaveName,win=DWS_Sizes_Panel, mode=1, value=\""+DiameterWaveName+"\"+\";---;\"+DWS_ListOfDist(\"Xaxis\")"	
				Execute (cmd)	
				Recover_Sizes_Parameters(DiameterWaveName)
				execute ("PopupMenu SelectQvector mode=1, value=root:Packages:Sizes:OriginalQvectorWvName,win=DWS_Sizes_Panel")
				execute ("PopupMenu SelectIntensity  mode=1,value=root:Packages:Sizes:OriginalIntensityWvName,win=DWS_Sizes_Panel")
				execute ("PopupMenu SelectError mode=1,value=root:Packages:Sizes:OriginalErrorWvName,win=DWS_Sizes_Panel")
		else
			DistributionWaveName=""
		endif
	endif
	
	if (cmpstr(ctrlName,"SelectFolderIntensity")==0)
		IR1R_PopMenuProc("SelectFolder",popNum,popStr)
		SVAR foldername=root:Packages:Sizes:DataFolderName
		foldername=popstr				
	endif
end

function/s Recover_Sizes_Parameters(SourcewaveName)
	string SourcewaveName
	SVAR workingfoldername=root:Packages:Sizes:DataFolderName
	SVAR OriginalIntensityWvName=root:Packages:Sizes:OriginalIntensityWvName
	SVAR OriginalQvectorWvName=root:Packages:Sizes:OriginalQvectorWvName
	SVAR OriginalErrorWvName=root:Packages:Sizes:OriginalErrorWvName
	SVAR MethodRun=root:Packages:Sizes:MethodRun	
	SVAR ShapeType=root:Packages:Sizes:ShapeType
	
	setdatafolder workingfoldername
	wave Sourcewave=$sourcewavename
	string wavenote=note(Sourcewave)
	
	OriginalIntensityWvName=StringByKey("SizesIntensity", wavenote ,"=",";")
	OriginalQvectorWvName=StringByKey("SizesQvector", wavenote ,"=",";")
	OriginalErrorWvName=StringByKey("SizesError", wavenote ,"=",";")
	string method="Method = "
	MethodRun=StringByKey("MethodRun", wavenote ,"=",";")
	method+=MethodRun
	string particleshape="\rShape = "
	ShapeType=StringByKey("ParticleShape", wavenote ,"=",";")
	
	particleshape+=ShapeType
	method+=particleshape
	string contrast="\rContrast = "+StringByKey("ScatteringContrast", wavenote ,"=",";")
	method+=contrast
	
	string units=StringByKey("units", wavenote ,"=",";")
	
	if ((stringmatch(particleshape, "*Spheroid" ))||(stringmatch(particleshape, "*AR" ))||(stringmatch(particleshape, "*rods" )))
		string aspectratio="\rAspect Ratio = "
		aspectratio+=StringByKey("AspectRatio", wavenote ,"=",";")
		method+=aspectratio
	endif
	if ((stringmatch(particleshape, "*rod" ))||(stringmatch(particleshape, "*tube" ))||(stringmatch(particleshape, "cylinder" )))
		string length="\rLength = "
		Length+=StringByKey("TubeLength", wavenote ,"=",";")
		method+=Length
	endif
	if ((stringmatch(particleshape, "*rod" ))||(stringmatch(particleshape, "*tube" ))||(stringmatch(particleshape, "cylinder" )))
		string Wallthickness="\rWallthickness = "
		Wallthickness+=StringByKey("TubeWallThickness", wavenote ,"=",";")
		method+=Wallthickness
	endif
	if ((stringmatch(shapetype, "Fractal Aggregate" )))
		string D="\rD = "
		D+=StringByKey("FractalDimension", wavenote ,"=",";")
		method+=D
		string Rpri="\rRpri = "
		Rpri+=StringByKey("FractalRadiusOfPriPart", wavenote ,"=",";")
		method+=Rpri
		
		
	endif
	
	string sizedatafrom="\r"
	sizedatafrom+=StringByKey("SizesDataFrom", wavenote ,"=",";")
	SVAR Distributionwavename=root:Packages:Sizes:DistributionWaveName	
	method+=sizedatafrom+"\r"+Distributionwavename
	return method
end

Function/T DWS_GenStringOfFolders2(fullpath)
	variable fullpath
	string ListOfQFolders=""
	string result=""
	ListOfQFolders+=IN2G_FindFolderWithWaveTypes("root:", 10, "*Sizes*", fullpath)	
	result+=ReturnListResultsFolders(ListOfQFolders)
	return result
end




Function DWS_GraphIntensityButton(ctrlName) : ButtonControl			//this function is called by button from the panel
	String ctrlName
	setDataFolder root:Packages:Sizes

		DoWIndow IR1R_SizesInputGraph
		if (V_Flag)
			DoWindow/K IR1R_SizesInputGraph
		endif

			DoWIndow IR1R_SizesInputGraph
		if (V_Flag)
			DoWIndow/K IR1R_SizesInputGraph
		endif
		SVAR FldrNm=root:Packages:Sizes:DataFolderName

		SVAR IntNm=root:Packages:Sizes:OriginalIntensityWvName
		SVAR QvcNm=root:Packages:Sizes:OriginalQvectorWvName
		SVAR ErrNm=root:Packages:Sizes:OriginalErrorWvName	
		//fix for liberal names
		IntNm=IN2G_RemoveExtraQuote(IntNm,1,1)
		QvcNm=IN2G_RemoveExtraQuote(QvcNm,1,1)
		ErrNm=IN2G_RemoveExtraQuote(ErrNm,1,1)
		IntNm= PossiblyQuoteName(IntNm)
		QvcNm= PossiblyQuoteName(QvcNm)
		ErrNm= PossiblyQuoteName(ErrNm)
		
	if ((strlen(IN2G_RemoveExtraQuote(IntNm,1,1))>0)&&(strlen(IN2G_RemoveExtraQuote(QvcNm,1,1))>0)&&(strlen(IN2G_RemoveExtraQuote(ErrNm,1,1))>0))
		Wave Int=$(FldrNm+IntNm)
		Wave Qvc=$(FldrNm+QvcNm)
		Wave Err=$(FldrNm+ErrNm)
		if ((numpnts(Int)==numpnts(Qvc))&&(numpnts(Int)==numpnts(Err)))
			
			execute ("DWS_SizesInputGraph()")
			
		else
			DoAlert 0, "The data DO NOT have same number of points. This indicates problem with data. Please fix the data to same length and try again..." 
		endif	
	endif	
END	

function DWS_SizesInputGraph()
		SVAR Datafolder=root:Packages:Sizes:DataFolderName
		setdatafolder Datafolder
		SVAR OriginalIntensityWvName=root:Packages:Sizes:OriginalIntensityWvName
		SVAR OriginalQvectorWvName=root:Packages:Sizes:OriginalQvectorWvName
		SVAR  OriginalErrorWvName=root:Packages:Sizes:OriginalErrorWvName
		wave OriginalIntensityWv=$OriginalIntensityWvName
      		wave OriginalQvectorWv=$OriginalQvectorWvName
      		wave OriginalErrorWv=$OriginalErrorWvName
      		
		if(cmpstr(WinList("Intensityplot",";","WIN:1"), "" )==0)
			Display/K=1/n=IntensityPlot  OriginalIntensityWv vs OriginalQvectorWv
			DoWindow /T IntensityPlot, "Scattering Data"
			Label left "\\Z14Intensity"
			Label bottom "\\Z14q(-1)"
			ModifyGraph margin(bottom)=50		
		else
			AppendToGraph OriginalIntensityWv vs  OriginalQvectorWv
		endif	
		string cmd  ="ModifyGraph mode("+OriginalIntensityWvName+")=3,marker("+OriginalIntensityWvName+")=8,rgb("+OriginalIntensityWvName+")=(0,0,0)"
		execute(cmd)
		//Tag/C/N=$Distributionwavename/L=1 $Distributionwavename, 50,Tagstring
		CheckforLog()		
		SVAR DiameterWaveName=root:Packages:Sizes:DiameterWaveName
		SVAR FitQvectorWvName=root:Packages:Sizes:FitQvectorWvName
		string SizesFitIntensityName="SizesFitIntensity"+DiameterWaveName[17,inf]		
		Wave SizesFitIntensityWave=$SizesFitIntensityName
		Wave SizesFitQvectorWave=$ FitQvectorWvName
		appendtograph SizesFitIntensityWave vs SizesFitQvectorWave	
		 cmd  ="ModifyGraph LSIZE("+SizesFitIntensityName+")=2"
		execute(cmd)	
end


Function/S DWS_RecoverOldParameters()
	
	string OldDf
	OldDf=GetDataFolder(1)
	setDataFolder root:Packages:Sizes

	SVAR fldrName				=root:Packages:Sizes:DataFolderName
	
	NVAR AspectRatio			=root:Packages:Sizes:AspectRatio
	NVAR Rmin					=root:Packages:Sizes:Rmin
	NVAR Rmax					=root:Packages:Sizes:Rmax
	NVAR Bckg					=root:Packages:Sizes:Bckg
	NVAR ScatteringContrast	=root:Packages:Sizes:ScatteringContrast
	SVAR ShapeType				=root:Packages:Sizes:ShapeType
	SVAR MethodRun			=root:Packages:Sizes:MethodRun
	variable DataExists=0,i
	string tempString
	string ListOfWaves=IN2G_CreateListOfItemsInFolder(fldrName, 2)
	if (stringmatch(ListOfWaves, "*SizesDistDiameter*" ))
		string ListOfSolutions=""
		For(i=0;i<itemsInList(ListOfWaves);i+=1)
			if (stringmatch(stringFromList(i,ListOfWaves),"*SizesDistDiameter*"))
				tempString=stringFromList(i,ListOfWaves)
				Wave tempwv=$(fldrName+tempString)
				tempString=stringByKey("UsersComment",note(tempwv),"=")
				ListOfSolutions+=stringFromList(i,ListOfWaves)+"*  "+tempString+";"
			endif
		endfor
		DataExists=1
		string ReturnSolution=""
		Prompt ReturnSolution, "Select solution to recover", popup,  ListOfSolutions
		DoPrompt "Previous solutions found", ReturnSolution
		if (V_Flag)
			abort
		endif
	else
		abort
	endif

	IF (DataExists==1 && cmpstr(ReturnSolution,"Start fresh")!=0)
		ReturnSolution=ReturnSolution[0,strsearch(ReturnSolution, "*", 0 )-1]
		Wave/Z OldDistribution=$(fldrName+ReturnSolution)
		variable StartFItQvalue
		variable EndFItQvalue
		wave Q_vecOriginal=root:Packages:Sizes:Q_vecOriginal
		
		string OldNote=note(OldDistribution)
		variable ParticlePar1=0,ParticlePar2=0,ParticlePar3=0,ParticlePar4=0,ParticlePar5=0
		
		if(cmpstr(ShapeType,"Algebraic_Integrated Spheres")==0)		//no parameter at all - it is sphere
			//no parameter
		elseif(cmpstr(ShapeType,"Cylinders")==0)						//Cylinder 1 poarameter - length
			NVAR CylinderLength=root:Packages:Sizes:CylinderLength	//CylinderLength
			CylinderLength			=NumberbyKey("CylinderLength", OldNote,"=")
		elseif(cmpstr(ShapeType,"User")==0)						//Cylinder 1 poarameter - length
			NVAR ParticlePar1G=root:Packages:Sizes:UserFFpar1
			ParticlePar1G			=NumberbyKey("UserParameter1", OldNote,"=")
			NVAR ParticlePar2G=root:Packages:Sizes:UserFFpar2
			ParticlePar2G			=NumberbyKey("UserParameter2", OldNote,"=")
			NVAR ParticlePar3G=root:Packages:Sizes:UserFFpar3
			ParticlePar3G			=NumberbyKey("UserParameter3", OldNote,"=")
			NVAR ParticlePar4G=root:Packages:Sizes:UserFFpar4
			ParticlePar4G			=NumberbyKey("UserParameter4", OldNote,"=")
			NVAR ParticlePar5G=root:Packages:Sizes:UserFFpar5
			ParticlePar5G			=NumberbyKey("UserParameter5", OldNote,"=")
		elseif(cmpstr(ShapeType,"CoreShell")==0)				//CoreShell - 2 parameters
			NVAR CoreShellThicknessRatio=root:Packages:Sizes:CoreShellThicknessRatio	//radius of primary particle
			CoreShellThicknessRatio	=NumberbyKey("CoreShellThicknessRatio", OldNote,"=")
			NVAR CoreShellContrastRatio=root:Packages:Sizes:CoreShellContrastRatio	
			CoreShellContrastRatio	=NumberbyKey("CoreShellContrastRatio", OldNote,"=")
		elseif(cmpstr(ShapeType,"Fractal aggregate")==0)				//Fractal aggregate - 2 parameters
			NVAR FractalRadiusOfPriPart=root:Packages:Sizes:FractalRadiusOfPriPart	//radius of primary particle
			FractalRadiusOfPriPart	=NumberbyKey("FractalRadiusOfPriPart", OldNote,"=")
			NVAR FractalDimension=root:Packages:Sizes:FractalDimension	
			FractalDimension			=NumberbyKey("FractalDimension", OldNote,"=")
		elseif((cmpstr(ShapeType,"Tube")==0)	||(cmpstr(ShapeType,"Unified_Tube")==0)	)//dws			//Tube - 3 parameters
			NVAR TubeLength=root:Packages:Sizes:TubeLength			//TubeLength
				TubeLength				=NumberbyKey("TubeLength", OldNote,"=")
			NVAR TubeWallThickness=root:Packages:Sizes:TubeWallThickness		//WallThickness
				TubeWallThickness		=NumberbyKey("TubeWallThickness", OldNote,"=")	
			NVAR TubeCoreContrastRatio=root:Packages:Sizes:TubeCoreContrastRatio		//CoreContrastRatio
				TubeCoreContrastRatio	=NumberbyKey("TubeCoreContrastRatio", OldNote,"=")	
		else												//the ones which require 1 parameter - aspect ratio or (Unif) thickness/length
			AspectRatio				=NumberbyKey("AspectRatio", OldNote,"=")
		endif
	ENDIF
	return returnsolution
end

